local ffi = require("lib.ffi")

local function _init(_ENV)
    assembly("mscorlib")
    assembly("UnityEngine")

    using("System")
    using("UnityEngine")
	
	class("EvilGameManager")
	   	 :static_method("void log(String)")

    class("StatSheetManager")
		 :static_method("void addStatSheet(String)")
		 
	class("CatalogManager")
		 :static_method("String get(String)")
		 
	class("StatSheet")
		:static_method("void setInfo	(StatSheet, String,String)")
		:static_method("void setGroup	(StatSheet, String,String,String)")
		:static_method("void setStat	(StatSheet, String,String,String,String)")
		
	class("StatsContainer")
		:static_method("void setStatVal(StatsContainer, String, String, float)")
		:static_method("void setStatValMin(StatsContainer, String, String, float, float  )")
		:static_method("void setStatValMax(StatsContainer, String, String, float, float, float  )")
		:static_method("void setStatValPool(StatsContainer, String, String, float, float, float, String )")
		:static_method("void setStat(StatsContainer, String, String, float )")
		:static_method("void setStat(StatsContainer, String, String, String )")
		:static_method("string getStatString(StatsContainer, String, String )")
		:static_method("float getStatValue(StatsContainer, String, String )")
		:static_method("void setStat_Reb(StatsContainer, String, String, float )")
		:static_method("void setStat_Add(StatsContainer, String, String, float )")
		:static_method("void setStat_Mul(StatsContainer, String, String, float )")
		:static_method("void setStat_Rep(StatsContainer, String, String, float )")
		
	class("GameUnitFactory")
		:static_method("void addGameUnit( String, String, String)")
		
	class("GameUnit")
		:static_method("void tag(GameUnit, String)")
		:static_method("void untag(GameUnit, String)")
		:static_method("void setLogic(GameUnit, String)")
		
	class("RPGUnit")
		:static_method("addInventoryContainer(RPGUnit, String, int, String, String)")
		:static_method("setInventorySlotTags(RPGUnit, String, int, String, String)")
		
	class("PerkFactory")
		:static_method("void addPerk(String, String)")
		
	class("CharacterController")
		:static_method("void registerStartingEquipment(String, String)")
		:static_method("void registerStartingPerks(String, String)")
		:static_method("void addPerkScript(String, RPGUnit, RPGUnit)")
		:static_method("void removePerkScript(String, RPGUnit)")
	    :static_method("void applyTraitPerk(String, RPGUnit)")
		:static_method("void removeTraitPerk(String, RPGUnit)")
		
	class("NPCController")
		:static_method("void registerToCategory(String, String, int)")
		
	class("ObjectController")
		:static_method("void registerToCategory(String, String, int)")
		:static_method("void registerToShop(String, String, int)")
		:static_method("void registerUnlockable(String, String, String, String, int)")
		
	class("ResourceTag")
		:static_method("void registerGameUnitTags(String, String)")
		
	class("GameGui")
		:static_method("void addPerkIcon(RPGUnit, Perk)")
		:static_method("void removePerkIcon(RPGUnit, Perk)")
				
	class("Loot")
		:static_method( "void addElement( string, float, string )" ) 
		
	class("LootTable")
		:static_method( "void addElement( string, int, float, string)" ) 
	
	class("GameUnitCategorizer")
		:static_method( "void register( string, string, float, int, int )" )
		:static_method( "void registerAffix( string, string, float, string, string, string )" )
		
	class("DropPreset")
		:static_method( "void addToPreset_Replace( DropPreset,  string, string, string)" )
		:static_method( "void addToPreset_And( DropPreset,  string, string, string )" )
		:static_method( "void addToPreset_Or( DropPreset,  string, string, string)" )
		:static_method( "void addToPreset_Resource( DropPreset,  float, float )" )
		:static_method( "void addToPresetExtra_Replace( DropPreset,  string, string, string)" )
		:static_method( "void addToPresetExtra_And( DropPreset,  string, string, string )" )
		:static_method( "void addToPresetExtra_Or( DropPreset,  string, string, string )" )
		:static_method( "void addToPresetExtra_Resource( DropPreset,  float, float )" )
		:static_method( "addToPresetExtra_Pack( DropPreset, string, string, string, string, string, string, string, string  )" )
		
	class("SCMZLevels")
		:static_method( "void registerLevelGroup( string, string, int, string, string, int )" )	
		:static_method( "LevelConfData getLevelConfiguration( string, int )") 
		
	class("LevelConfData")
		:field("string scene")
		:field("string levelId")
		:field("int roomsCount")
		:field("float secondaryComplexity")
		:field("float secondaryLength")
		:field("string tileset")
		:field("string signatureTagset")
		:field("string ambientSettings")
		:field("bool editorOnly")
		:field("float monstersPoints")
		:field("int difficultyShift")
		:field("string endingSequence")
		:field("string startingSequence")
		:field("string mainCourseRoomTypes")
		:field("string secondaryCourseRoomTypes")
		:field("string secondaryCourseLastRoom")
		:method("void registerMeteorSystem(string, float, float, string, string)" )
		:method("void setPreferredDirection_Up( int )" )
		:method("void setPreferredDirection_Down( int )" )
		:method("void setPreferredDirection_Left( int )" )
		:method("void setPreferredDirection_Right( int )" )
end

local GameEngine = ffi.build(_init) 

 GameManager 			= GameEngine.EvilGameManager
 StatSheetManager 		= GameEngine.StatSheetManager
 Catalog 				= GameEngine.CatalogManager
 StatSheet 				= GameEngine.StatSheet
 StatsContainer 		= GameEngine.StatsContainer
 GameUnitFactory 		= GameEngine.GameUnitFactory
 GameUnit 				= GameEngine.GameUnit
 RPGUnit 				= GameEngine.RPGUnit
 Perk 					= GameEngine.Perk
 PerkFactory 			= GameEngine.PerkFactory
 CharacterController 	= GameEngine.CharacterController
 NPCController 			= GameEngine.NPCController
 ObjectController 		= GameEngine.ObjectController
 ResourceTag 			= GameEngine.ResourceTag;
 GameGui 				= GameEngine.GameGui
 Loot 					= GameEngine.Loot
 LootTable 				= GameEngine.LootTable
 GameUnitCategorizer 	= GameEngine.GameUnitCategorizer
 DropPreset				= GameEngine.DropPreset
 SCMZLevels				= GameEngine.SCMZLevels