local assets=
{
	Asset("ANIM", "anim/stinger.zip"),
    Asset("ANIM", "anim/wathgrithr.zip"),
    Asset("SOUND", "sound/wathgrithr.fsb"),
}



local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("stinger")
    inst.AnimState:SetBuild("stinger")
    inst.AnimState:PlayAnimation("idle")
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
local slotpos = {}
for y = 5, 0, -1 do
    for x = 0, 2 do
        table.insert(slotpos, Vector3(75*x-75*2+75, 75*y-75*2+75,0))
    end
end
local widgetbuttoninfo = {
    text = "Do",
    position = Vector3(68, 361, 0),
    fn = function(inst)
        GetPlayer().SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
        if not inst:HasTag("withme") then
           inst:AddTag("withme")
           local brain = require "brains/chesterbrain"
           inst:SetBrain(brain)
           inst:RestartBrain()
           inst.components.follower:SetLeader(GetPlayer())
        else
           inst:RemoveTag("withme")
           inst.components.locomotor:Stop()
           inst:SetBrain(nil)
           inst.components.follower:SetLeader(nil)
        end
end }
local function OnDeploy (inst, pt)
    local girl = SpawnPrefab("stinger")
    girl.Transform:SetPosition(pt.x, pt.y, pt.z)
    girl.AnimState:SetBank("wilson")
    local girlnames = {"wendy","willow","wathgrithr"}
    girl.buildname = girlnames[math.random(#girlnames)]
    girl.AnimState:SetBuild(girl.buildname)
    girl.AnimState:PlayAnimation("idle")
    girl.AnimState:Show("ARM_normal") 
    girl.AnimState:Hide("ARM_carry")
    girl.Transform:SetFourFaced()
    girl.entity:AddSoundEmitter()
    local shadow = girl.entity:AddDynamicShadow()
    shadow:SetSize( 1.3, .6 )
    MakeCharacterPhysics(girl, 75, .5)
    local minimap = girl.entity:AddMiniMapEntity()
    minimap:SetIcon( "wendy.png" )
    girl:RemoveComponent("stackable")
    girl:RemoveComponent("inventoryitem")
    girl:RemoveComponent("deployable")
    girl:AddComponent("named")
    girl.components.named:SetName("My Baby")
    girl:AddComponent("knownlocations")
    girl:AddComponent("follower")
    girl.components.follower:SetLeader(GetPlayer())
    girl:AddComponent("inventory")
    girl.components.container.canbeopened = true
    girl:AddComponent("locomotor")
    girl.components.locomotor.walkspeed = 8
    girl.components.locomotor.runspeed = 12
    girl:SetStateGraph("SGshadowwaxwell")
    local brain = require "brains/chesterbrain"
    girl:SetBrain(brain)
    girl:AddComponent("combat")
    girl:AddComponent("health")
    girl.components.health:SetMaxHealth(2000)
    girl:ListenForEvent("death", function()
        girl.components.container:DropEverything()
    end )
    girl:AddComponent("talker")
    girl:DoPeriodicTask(60, function()
        local words = {"I love you","You are my love","I like you","I want stay with you","I miss you","you are my darling","I am your sweetheart","You have to love me","Don't go","Are you hungry"}
        local word = words[math.random(#words)]
        girl.components.talker:Say(word, 4, false)
        girl.components.health:DoDelta(2000)
    end)
    girl:DoPeriodicTask(400, function()
        local names = {"waffles","turkeydinner","baconeggs"}
        local name = names[math.random(#names)]
        local foods = SpawnPrefab(name)
        girl.components.container:GiveItem(foods)
        girl.components.talker:Say("Come to eat", 4, false)
    end)
    girl:AddComponent("machine")
    girl.components.machine.turnonfn = function(girl)
        girl.components.machine.ison = true
        girl:AddTag("neat")
        local hats = {"hat_flower","hat_earmuffs","hat_feather","hat_slurper","hat_spider","hat_straw","hat_top","hat_walrus","hat_winter","hat_beefalo","hat_rain","hat_catcoon"}
        girl.hat = hats[math.random(#hats)]
        local armors = {"armor_sweatervest","armor_trunkvest_summer","armor_trunkvest_winter","armor_sanity","armor_slurper","torso_rain"}
        girl.armor = armors[math.random(#armors)]
        girl.sg:GoToState("hit")
        girl.AnimState:OverrideSymbol("swap_hat", girl.hat, "swap_hat")
        girl.AnimState:OverrideSymbol("swap_body", girl.armor, "swap_body")
        girl.AnimState:Show("HAT")
        girl.AnimState:Show("HAT_HAIR")
        girl.AnimState:Hide("HAIR_NOHAT")
        girl.AnimState:Hide("HAIR")
        local words = {"I like it","I don't loke it"}
        local word = words[math.random(#words)]
        girl.components.talker:Say(word, 4, false)
    end
    girl.components.machine.turnofffn = function(girl)
        girl.components.machine.ison = false
        girl:RemoveTag("neat")
        girl.sg:GoToState("stunned")
        girl.AnimState:Hide("HAT")
        girl.AnimState:Hide("HAT_HAIR")
        girl.AnimState:Show("HAIR_NOHAT")
        girl.AnimState:Show("HAIR")
        girl.AnimState:ClearOverrideSymbol("swap_body")
        girl.SoundEmitter:PlaySound("dontstarve/characters/wendy/hurt")
        girl.components.talker:Say("Don't, Don't, Don't", 4, false)
    end
    girl:AddComponent("sanityaura")
    girl.components.sanityaura.aura = TUNING.SANITYAURA_HUGE
    girl:ListenForEvent("attacked", function(girl, data)
       girl.sg:GoToState("stunned")
       girl.SoundEmitter:PlaySound("dontstarve/characters/wendy/hurt")
       girl.components.talker:Say("Don't, Don't, Don't", 4, false)
    end )
    girl:AddTag("fridge")
    girl:AddTag("withme")
    girl:AddTag("companion")
    girl:AddTag("girls")
    inst.components.stackable:Get():Remove()
end
    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = OnDeploy
    inst:AddComponent("container")
    inst.components.container.widgetbuttoninfo = widgetbuttoninfo
    inst.components.container:SetNumSlots(#slotpos)
    inst.components.container.widgetslotpos = slotpos
    inst.components.container.widgetpos = Vector3(0,150,0)
    inst.components.container.side_align_tip = 160
    inst.components.container.canbeopened = false
local function onsave(inst, data)
    if inst:HasTag("girls") then
        data.girls = true
    end
    if inst:HasTag("withme") then
        data.withme = true
    end
    if inst:HasTag("neat") then
        data.neat = true
    end
    data.buildname = inst.buildname
    data.hat = inst.hat
    data.armor = inst.armor
end
local function onload(inst, data)
  if data and data.girls then
    inst.AnimState:SetBank("wilson")
    local girlnames = {"wendy","willow","wathgrithr"}
    inst.buildname = girlnames[math.random(#girlnames)]
    inst.AnimState:SetBuild(inst.buildname)
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:Show("ARM_normal") 
    inst.AnimState:Hide("ARM_carry")
    inst.Transform:SetFourFaced()
    inst.entity:AddSoundEmitter()
    local shadow = inst.entity:AddDynamicShadow()
    shadow:SetSize( 1.3, .6 )
    MakeCharacterPhysics(inst, 75, .5)
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon( "wendy.png" )
    inst:RemoveComponent("stackable")
    inst:RemoveComponent("inventoryitem")
    inst:RemoveComponent("deployable")
    inst:AddComponent("named")
    inst.components.named:SetName("My Baby")
    inst:AddComponent("knownlocations")
    inst:AddComponent("follower")
    inst:AddComponent("inventory")
    inst.components.container.canbeopened = true
    inst:AddComponent("locomotor")
    inst.components.locomotor.walkspeed = 8
    inst.components.locomotor.runspeed = 12
    inst:SetStateGraph("SGshadowwaxwell")
    inst:AddComponent("combat")
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(2000)
    inst:ListenForEvent("death", function()
        inst.components.container:DropEverything()
    end )
    inst:AddComponent("talker")
    inst:DoPeriodicTask(60, function()
        local words = {"I love you","You are my love","I like you","I want stay with you","I miss you","you are my darling","I am your sweetheart","You have to love me","Don't go","Are you hungry"}
        local word = words[math.random(#words)]
        inst.components.talker:Say(word, 4, false)
        inst.components.health:DoDelta(2000)
    end)
    inst:DoPeriodicTask(400, function()
        local names = {"waffles","turkeydinner","baconeggs"}
        local name = names[math.random(#names)]
        local foods = SpawnPrefab(name)
        inst.components.container:GiveItem(foods)
        inst.components.talker:Say("Come to eat", 4, false)
    end)
    inst:AddComponent("machine")
    inst.components.machine.turnonfn = function(inst)
        inst.components.machine.ison = true
        inst:AddTag("neat")
        local hats = {"hat_flower","hat_earmuffs","hat_feather","hat_slurper","hat_spider","hat_straw","hat_top","hat_walrus","hat_winter","hat_beefalo","hat_rain","hat_catcoon"}
        inst.hat = hats[math.random(#hats)]
        local armors = {"armor_sweatervest","armor_trunkvest_summer","armor_trunkvest_winter","armor_sanity","armor_slurper","torso_rain"}
        inst.armor = armors[math.random(#armors)]
        inst.sg:GoToState("hit")
        inst.AnimState:OverrideSymbol("swap_hat", inst.hat, "swap_hat")
        inst.AnimState:OverrideSymbol("swap_body", inst.armor, "swap_body")
        inst.AnimState:Show("HAT")
        inst.AnimState:Show("HAT_HAIR")
        inst.AnimState:Hide("HAIR_NOHAT")
        inst.AnimState:Hide("HAIR")
        local words = {"I like it","I don't loke it"}
        local word = words[math.random(#words)]
        inst.components.talker:Say(word, 4, false)
    end
    inst.components.machine.turnofffn = function(inst)
        inst.components.machine.ison = false
        inst:RemoveTag("neat")
        inst.sg:GoToState("stunned")
        inst.AnimState:Hide("HAT")
        inst.AnimState:Hide("HAT_HAIR")
        inst.AnimState:Show("HAIR_NOHAT")
        inst.AnimState:Show("HAIR")
        inst.AnimState:ClearOverrideSymbol("swap_body")
        inst.SoundEmitter:PlaySound("dontstarve/characters/wendy/hurt")
        inst.components.talker:Say("Don't, Don't, Don't", 4, false)
    end
    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aura = TUNING.SANITYAURA_HUGE
    inst:ListenForEvent("attacked", function(inst, data)
       inst.sg:GoToState("stunned")
       inst.SoundEmitter:PlaySound("dontstarve/characters/wendy/hurt")
       inst.components.talker:Say("Don't, Don't, Don't", 4, false)
    end )
    inst:AddTag("fridge")
    inst:AddTag("companion")
    inst:AddTag("girls")
  end
  if data and data.withme then
    inst:AddTag("withme")
    local brain = require "brains/chesterbrain"
    inst:SetBrain(brain)
    inst:RestartBrain()
    inst.components.follower:SetLeader(GetPlayer())
  end
  if data and data.neat then
    inst.components.machine.ison = true
    inst:AddTag("neat")
    inst.AnimState:Show("HAT")
    inst.AnimState:Show("HAT_HAIR")
    inst.AnimState:Hide("HAIR_NOHAT")
    inst.AnimState:Hide("HAIR")
    if data and data.hat then
       inst.hat = data.hat
       inst.AnimState:OverrideSymbol("swap_hat", inst.hat, "swap_hat")
    end
    if data and data.armor then
       inst.armor = data.armor
       inst.AnimState:OverrideSymbol("swap_body", inst.armor, "swap_body")
    end
  end
  if data and data.buildname then
     inst.buildname = data.buildname
     inst.AnimState:SetBuild(inst.buildname)
  end
end
    inst.OnSave = onsave
    inst.OnLoad = onload

    
    inst:AddComponent("inventoryitem")
    return inst
end

return Prefab( "common/inventory/stinger", fn, assets) 
