//#define FULL_VIEWPORT
#define PI           3.1415926f
#define ASPECT_RATIO 0.70706   //(4096.0f/5793.0f)
#define VIEW_VECTOR  float3(0.0f, 0.816515f, 0.577325f)//y = sqrt(1 / (1 + sqr(ASPECT_RATIO))), z = y * ASPECT_RATIO


//##########################################################################################################
float4   LightColor;
float3   LightCoor;
float    LightRadius2;//     
//float    DirectLightNormal;// compressed to 10 bit
float    ObjectDirection;//   ,     (  5 )
float4   ZCoeff;

texture  RenderTargetTexture;
sampler RenderTarget = 
sampler_state
{
    Texture = <RenderTargetTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
};

texture  GBufferTexture;
sampler GBuffer = 
sampler_state
{
    Texture = <GBufferTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
};

texture SurfaceTexture;
sampler Surface = 
sampler_state
{
    Texture = <SurfaceTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
};

texture DecodeTexture;
sampler Decode = 
sampler_state
{
    Texture = <DecodeTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
};

texture LightCalcTexture;
sampler LightCalc = 
sampler_state
{
    Texture = <LightCalcTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
};

//#define ASPECT_RATIO (4096.0 / 5793.0)
half4 ps20DrawLight( in half2 TextureCoor : TEXCOORD0,
                     in half4 Coor        : TEXCOORD1 ) : COLOR
{
    half4 color = tex2D(RenderTarget, TextureCoor);
    half4 c = Coor + color.a * ZCoeff;
//    return color * (1 - dot(Coor, Coor));
//    return color * (LightColor / (dot(Coor, Coor) + 0.04) - 0.2);
//    float intensive = dot(Coor, Coor); intensive = 42 * intensive * (intensive - 1) + 5;
//    float intensive = 0.2 / (dot(Coor, Coor) + 0.02) - 0.2;
//    float intensive = 1 / (dot(Coor, Coor) + 0.00) - 1;

//    float intensive = 1 / dot(Coor, Coor) - 1;
//    return LightColor * intensive * color;
//    return LightColor * color * (1 / dot(Coor, Coor) - 1);
//    color.a = 1;
    return color * (LightColor / dot(c, c) - LightColor);
}
technique DrawLight20
{
    pass P0
    {        
        Sampler[0] = <RenderTarget>;
        PixelShader = compile ps_2_0 ps20DrawLight();
/*        PixelShader =
             asm
             {
                 ps_2_0
                 def    c0, 0.2, 0.2, 0.2, 0.2 // LightColor
                 def    c1, 0.0, 4.0, -4.0, 0.0 // ZCoeff
                 dcl    t0.xy
                 dcl    t1.xyzw
                 dcl_2d s0
                 texld_pp  r0, t0, s0
                 mad r1, r0.aaaa, c1, t1
                 dp4_pp r1.a, r1, r1
                 mul_pp r0, r0, c0
                 rcp_pp r1.a, r1.a
                 mad_pp r0, r1.aaaa, r0, -r0
                 mov_pp    oC0, r0
             };*/
    }
}

float4 ps10DrawLight( in float2 TextureCoor : TEXCOORD0,
                      in float3 Coor        : TEXCOORD1 ) : COLOR
{
    float4 color  = tex2D(RenderTarget, TextureCoor);

    float3 c = 2 * (Coor - float3(0.5, 0.5, 0.5)) + color.a * ZCoeff;
//    float coeff = saturate(dot(c, c));
//    coeff = coeff * (coeff < 0.5? 1.0: 2.0);
//    return LightColor * color * saturate(1 - coeff) * 4;
    return LightColor * color * saturate(1.0 - dot(c, c)) * 4;

//    Coor += color.a * ZCoeff;
//    float intensive = saturate(1 - dot(Coor, Coor));
//    return 4 * (LightColor * color * intensive);
}

technique DrawLight10
{
    pass P0
    {        
        Sampler[0] = <RenderTarget>;
        PixelShader = compile ps_1_1 ps10DrawLight();
/*asm
{
    ps_1_1
    
//    def c0, 0.7, 0.7, 0.7, 0.7
    def    c1, 0.0, 4.0, -4.0, 0.0 // ZCoeff
    def    c2, 1.1, 1.1, 1.1, 1.1
    def    c3, 2.9, 1.9, 1.9, 2.9

    tex t0
    texcoord t1

    mad r1, t0.a, c1, t1_bx2
    dp3_x2 r0, r1, r1
//    mul r1, r1, c2

//    mad_sat r1, c0, r1
//    cnd r1, r0.a, c2.a, c3.a
//    mul r1, r1.a, r0.a
    mul_x4  r0, t0, 1 - r0

//    mul_x4 r0, t0, 1 - r1

};*/
    }
}

//##########################################################################################################
//   
/*technique DrawLightScreen
{
    pass P0
    {        
        Sampler[0] = <RenderTarget>;
//        PixelShader = compile ps_1_1 ps11DrawLightScreen();
    }
}
*/

//##########################################################################################################
float4   Specular;
float4   Diffuse;//: register (c0);
float2   TexShift;
float2   TexSize;
//float3   TransformScale;//       
//float3   TransformShift;//       
float2   TargetSize; //  rendertarget 
float2   TargetMul;  //     rendertarget 
float2   TargetShift;// ViewMin     rendertarget 
float4x4 mWorldView;
float4x4 mProjection;
float4x4 mView;
float4x4 mCommonMatrix;
//float ShiftZ;
// Transform objects into the view, also setting the appropriate blur factor
void vs10VertexTransformWithZ( float3     vPos      : POSITION,
//                             float2 vTexCoord0 : TEXCOORD0
                               out float4 oPosition : POSITION,
                               out float4 oDiffuse  : COLOR0,
                               out float4 oSpecular : COLOR1,
                               out float2 oTex      : TEXCOORD0 )
{
//    Output.Diffuse.a = max(vPos/*Output.Position*/.z + ShiftZ, 2) / 512;
    // tranform the position/normal into view space
    oPosition = mul(float4(vPos, 1.0f), mWorldView);
    oDiffuse.a = max(oPosition.z, 2) / 512;
    oPosition = mul(oPosition, mView);
    oPosition = mul(oPosition, mProjection);

    oDiffuse.rgb = Diffuse.rgb;
    oSpecular = Specular;
    
//    Output.Texture = (float2(vPos.x, vPos.y * (4096.0f/5793.0f) - vPos.z) + ShiftTex.xy) / SizeTex.xy;//float2(1.0-vTexCoord0.x, vTexCoord0.y);
    vPos.y = vPos.y * ASPECT_RATIO - vPos.z;
    oTex = (vPos.xy + TexShift) / TexSize;
//    Output.Texture = (vPos * TexSize + TexShift).xy;
//    Output.Texture = vTexCoord0;
    
}
void vs10VertexTransform( float3 vPos          : POSITION,
//                        float2 vTexCoord0 : TEXCOORD0
                          out float4 oPosition : POSITION,
                          out float4 oDiffuse  : COLOR0,
                          out float4 oSpecular : COLOR1,
                          out float2 oTex      : TEXCOORD0 )
{
    oDiffuse  = Diffuse;
    oSpecular = Specular;

    // tranform the position/normal into view space
//    vPos      = vPos * TransformScale + TransformShift;//   
    oPosition = mul(float4(vPos, 1.0f), mWorldView);
//    oDiffuse.r= saturate(oPosition.z/512);
    oPosition = mul(oPosition, mView);
    oPosition = mul(oPosition, mProjection);


    vPos.y = vPos.y * ASPECT_RATIO - vPos.z;
    oTex = (vPos.xy + TexShift) / TexSize;
}
float4 ps10DrawObjectWithZ(
//    in float4 diffuse     : COLOR0,
    in float2 TextureCoor : TEXCOORD0 ) : COLOR
{
    float4 color  = tex2D(RenderTarget, TextureCoor);
//    color = color * Diffuse + Specular;
    return color;
}
technique DrawObjectWithZ
{
    pass P0
    {        
//        Sampler[0] = <RenderTarget>;
        VertexShader = compile vs_1_1 vs10VertexTransformWithZ();
//        PixelShader = compile ps_1_1 ps10DrawObjectWithZ();
/*        PixelShader =
             asm
             {
                 ps_1_1
                 tex t0
                 mad r0, t0, v0, v1
             };*/

    }
}
technique DrawObject
{
    pass P0
    {        
        VertexShader = compile vs_1_1 vs10VertexTransform();
    }
}

//     
void vs10ArrayObjects( float3 vPos          : POSITION,
                       float4 iDiffuse      : COLOR0,
                       float4 iSpecular     : COLOR1,
                       float2 iTexCoord     : TEXCOORD0,
                       out float4 oPosition : POSITION,
                       out float4 oDiffuse  : COLOR0,
                       out float4 oSpecular : COLOR1,
                       out float2 oTex      : TEXCOORD0 )
{
    // tranform the position/normal into view space
    oPosition = mul(float4(vPos, 1.0f), mView);
    oPosition = mul(oPosition, mProjection);

//    vPos.y = vPos.y * ASPECT_RATIO - vPos.z;
    oTex      = iTexCoord;//(vPos.xy + TexShift) / TexSize;
    oDiffuse  = iDiffuse;
    oSpecular = iSpecular;
}
technique DrawArrayObjects
{
    pass P0
    {        
        VertexShader = compile vs_1_1 vs10ArrayObjects();
    }
}
void vs10VertexTransformLightWithZ( float3     vPos      : POSITION,
//                                  float2 vTexCoord0 : TEXCOORD0
                                    out float4 oPosition : POSITION,
                                    out float4 oDiffuse  : COLOR0,
                                    out float4 oSpecular : COLOR1,
                                    out float2 oTex      : TEXCOORD0 )
{
//    Output.Diffuse.a = max(vPos/*Output.Position*/.z + ShiftZ, 2) / 512;
    // tranform the position/normal into view space
    oPosition = mul(float4(vPos, 1.0f), mWorldView);
    oDiffuse.a = max(oPosition.z, 2) / 512;
    oPosition = mul(oPosition, mView);
    oPosition = mul(oPosition, mProjection);

    oDiffuse.rgb = Diffuse.rgb;
    oSpecular = Specular;
    
    vPos.y = vPos.y * ASPECT_RATIO - vPos.z;
    oTex = (vPos.xy + TexShift) / TexSize;
    
}
technique DrawLightWithZ
{
    pass P0
    {        
        VertexShader = compile vs_1_1 vs10VertexTransformLightWithZ();
    }
}
//##########################################################################################################
technique DrawObjectWithoutShader
{
    pass P0
    {        
        fvf = XYZ | Tex1;
    }
}

//##########################################################################################################
void ps20DrawBackWithZ( in  float2 TextureCoor: TEXCOORD0, 
                        out float4 oColor     : COLOR0, 
                        out float  oDepth     : Depth )
{
    float4 color  = tex2D(RenderTarget, TextureCoor);
    oColor = color;
    oDepth = color.a * 0.0625 + 0.015625;
}
technique DrawBackWithZ
{
    pass P0
    {        
        Sampler[0] = <RenderTarget>;
        PixelShader = compile ps_2_0 ps20DrawBackWithZ();
/*        PixelShader =
            asm
            {
                ps_2_0
                def    c0, 0.015625, 0, 0, 0.0625
                dcl    t0.xy
                dcl_2d s0
                texld  r0, t0, s0
                mov    oC0, r0
                mad_pp r1.a, r0.a, c0.w, c0.x
                mov    oDepth, r1.a
            };*/
    }
}
//##########################################################################################################
float4 ps10VolumeFog( in float2 TextureCoor: TEXCOORD0,
                      in float4 Diffuse:     COLOR0,
                      in float4 Specular:    COLOR1 ) : COLOR
{
    float4 color  = tex2D(RenderTarget, TextureCoor);
    color = color * Diffuse + Specular;
    return color;
}

technique DrawVolumeFog
{
    pass P0
    {        
        Sampler[0] = <RenderTarget>;
        PixelShader = compile ps_1_1 ps10VolumeFog();
/*asm
{
    ps_1_1
    
//    def c0, 0.7, 0.7, 0.7, 0.7
    def    c1, 0.0, 4.0, -4.0, 0.0 // ZCoeff
    def    c2, 1.1, 1.1, 1.1, 1.1
    def    c3, 2.9, 1.9, 1.9, 2.9

    tex t0
    texcoord t1

    mad r1, t0.a, c1, t1_bx2
    dp3_x2 r0, r1, r1
//    mul r1, r1, c2

//    mad_sat r1, c0, r1
//    cnd r1, r0.a, c2.a, c3.a
//    mul r1, r1.a, r0.a
    mul_x4  r0, t0, 1 - r0

//    mul_x4 r0, t0, 1 - r1

};*/
    }
}
//##########################################################################################################
//    
/*float4 ps20DrawLightWithNormals( in float2 TextureCoor: TEXCOORD0,
                               in float4 Diffuse:     COLOR0,
                               in float4 Specular:    COLOR1 ) : COLOR
{
    float4 index = tex2D(RenderTarget, TextureCoor);
    float4 color = tex2D(Decode, float2(index.a, 0.0f));
//    color = color * Diffuse + Specular;
    return color;
}

technique DrawNormalsTexture
{
    pass P0
    {        
        Sampler[0] = <RenderTarget>;
//        Sampler[1] = <Decode>;
        VertexShader = compile vs_1_1 vs10VertexTransform();
        PixelShader = compile ps_2_0 ps20DrawNormalsTexture();
    }
}*/
//##########################################################################################################
//    ()

float4 ps20DrawSunLight( in float2 TextureCoor: TEXCOORD0,
                         in float4 Diffuse:     COLOR0,
                         in float4 Specular:    COLOR1 ) : COLOR
{
// used LightColor, DecodeTexture, GBufferTexture
    float4 gbuffer = tex2D(GBuffer, TextureCoor);
    return LightColor * tex2D(Decode, gbuffer.rg);
}

technique DrawSunLight
{
    pass P0
    {        
        Sampler[0] = <GBuffer>;
        Sampler[1] = <Decode>;
        PixelShader = compile ps_2_0 ps20DrawSunLight();
    }
}

//##########################################################################################################
//    ()

void vs11DrawSpotLight( float3 vPos          : POSITION,
                        out float4 oPosition : POSITION,
                        out float2 oTex      : TEXCOORD0, //     
                        out float3 oCoor     : TEXCOORD1 )//      
{
    // tranform the position/normal into view space
    oPosition = mul(float4(vPos, 1.0f), mWorldView);
    oPosition = mul(oPosition, mView);
    oPosition = mul(oPosition, mProjection);

    oTex  = oPosition.xy * TargetMul + TargetShift;
    //       
    oCoor = LightCoor - float3(oTex * TargetSize / 512, 0);
    oCoor.y /= ASPECT_RATIO;
}

float4 ps20DrawSpotLight( in float2 TextureCoor: TEXCOORD0,
                          in float3 iCoor      : TEXCOORD1 ) : COLOR
{
// used LightColor, LightRadius2, DecodeTexture, GBufferTexture
    float4 gbuffer      = tex2D(GBuffer, TextureCoor);
    float3 light_normal = iCoor - gbuffer.a * float3(0, 1 / ASPECT_RATIO, 1);
    float  length2 = dot(light_normal, light_normal);
    light_normal = normalize(light_normal);//light_normal * rsqrt(length2);
    float diffuse = saturate(dot(tex2D(Decode, gbuffer.rg).xyz * 2 - 1, light_normal));
//    float specular = pow(saturate(dot(tex2D(Decode, color.rg).xyz * 2 - 1, normalize(light_normal + VIEW_VECTOR))), 20);
    float specular = pow(clamp(dot(reflect(-VIEW_VECTOR, tex2D(Decode, gbuffer.rg).xyz * 2 - 1), light_normal), 0.0, 1.0), 20);
    float light = (1 - length2 * LightRadius2) * (diffuse + specular);// * rsqrt(length2);
    return saturate(light/4);
}

technique DrawSpotLight
{
    pass P0
    {        
        Sampler[0]   = <RenderTarget>;
        Sampler[1]   = <Decode>;
//        Sampler[2]   = <Surface>;
        VertexShader = compile vs_1_1 vs11DrawSpotLight();
        PixelShader  = compile ps_2_0 ps20DrawSpotLight();
    }
}

//##########################################################################################################
//    
/*texture NormalsPointLightTexture;
sampler NormalsPointLight = 
sampler_state
{
    Texture = <NormalsPointLightTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
};*/

void vs10DrawPointLight( float3 vPos          : POSITION,
                         out float4 oPosition : POSITION,
                         out float2 oTex      : TEXCOORD0,
                         out float3 oCoor     : TEXCOORD1 )//     
{
    // tranform the position/normal into view space
    oPosition = mul(float4(vPos, 1.0f), mWorldView);
    oPosition = mul(oPosition, mView);

//    oCoor = (mul(LightCoor, (float3x3)mView) - oPosition) / 512;
    oCoor = ((float3)mul(float4(LightCoor.xy, 0, 0), mView) - oPosition);
    oCoor.y /= ASPECT_RATIO;
    oCoor.z = LightCoor.z;
    oCoor /= 512;

    oPosition = mul(oPosition, mProjection);

    oTex  = oPosition.xy * TargetMul + TargetShift;// oTex  = (oPosition.xy + TargetShift) * TargetMul;
    //       
//    oCoor = LightCoor - float3(oTex * TargetSize / 512, 0);
//    oCoor.y /= ASPECT_RATIO;
}

float4 ps20DrawPointLight( in float2 TextureCoor: TEXCOORD0,
                           in float3 iCoor      : TEXCOORD1 ) : COLOR
{
// used LightColor, LightRadius2 - 1/r2, DecodeTexture, GBufferTexture
    float4 gbuffer      = tex2D(GBuffer, TextureCoor);
    float3 normal       = tex2D(Decode, gbuffer.rg).xyz * 2 - 1;
    float3 light_normal = iCoor - gbuffer.a * float3(0, 1 / ASPECT_RATIO, 1);
    float  length2      = dot(light_normal, light_normal);
    light_normal = normalize(light_normal);//light_normal * rsqrt(length2);// 
    float  diffuse      = saturate(dot(normal, light_normal))/2;
//    float  specular = pow(saturate(dot(tex2D(Decode, color.rg).xyz * 2 - 1, normalize(light_normal + VIEW_VECTOR))), 20);
    float  specular     = pow(clamp(dot(reflect(-VIEW_VECTOR, normal), light_normal), 0.0, 1.0), 20);
    float4 light        = (1 - length2 * LightRadius2) * float4(diffuse,diffuse, diffuse, specular);// * rsqrt(length2);
//    float4 diff_spec = lit(dot(tex2D(Decode, color.rg).xyz * 2 - 1, light_normal), dot(tex2D(Decode, color.rg).xyz * 2 - 1, normalize(light_normal + VIEW_VECTOR)), 20);
//    float light = (1 - length2 * LightRadius2) * (diff_spec.y + diff_spec.z);// * rsqrt(length2);
//    float4 light         = (1 - length2 * LightRadius2) * (diffuse + specular);// * tex2D(RenderTarget, TextureCoor);
    return saturate(light);// * LightColor;
/*   
    float4 g_buffer = tex2D(RenderTarget, TextureCoor);// r - palette, g - ID palette( material  ), b - z, a - normal
    coor += float3(0, g_buffer.b, g_buffer.b);

1   coor = normalize(coor);
1   float3 normal = tex2D(Decode, float2(color.a, 0));
1   float  light = dot(coor, normal) + dot(normal, normalize(coor + v));

2   float  light_normal = tex3D(LightNormal, coor);//        
2   float  light = tex3D(LightCalc, float2(g_buffer.a, light_normal.a, g_buffer.g));

    float4 color = tex2D(Palette, g_buffer.rg);
    return color * light
*/
}

technique DrawPointLight
{
    pass P0
    {        
        Sampler[0]   = <GBuffer>;
        Sampler[1]   = <Decode>;
//        Sampler[2]   = <RenderTarget>;
        PixelShader  = compile ps_2_0 ps20DrawPointLight();
        VertexShader = compile vs_1_1 vs10DrawPointLight();
    }
}

//##########################################################################################################
//      ,     rendertarget

void vs10DrawObjectForPointLight( in  float3 vPos        : POSITION,
                                  out float4 oPosition   : POSITION,
                                  out float4 oLightNormal: COLOR0,
                                  out float2 oTex        : TEXCOORD0 )
{
// used mWorldView, mView, mProjection, TargetShift, TargetSize, LightCoor//, LightColor, NormalsPointLight, DecodeTexture, RenderTargetTexture
    //      

    // tranform the position/normal into view space
//    vPos      = vPos * TransformScale + TransformShift;//   
    oPosition = mul(float4(vPos, 1.0f), mWorldView);
    float3 light_vector = oPosition.xyz - LightCoor;
    oPosition = mul(oPosition, mView);
    oPosition = mul(oPosition, mProjection);

    oTex  = oPosition.xy * TargetMul + TargetShift;
    float3 light_normal = normalize(light_vector);
//    oLightNormal.x = (atan2(light_normal.x, -light_normal.y)/PI + 1)/2;// hor   Pi/2 - dir
//    oLightNormal.y = 0.5 - asin(light_normal.z)/PI;// vert
//    oLightNormal.z = 2000 / dot(light_vector, light_vector);//200 / dot(light_vector, light_vector);//1 / dot(vPos - LightCoor, vPos - LightCoor);
//    oLightNormal.a = 1;//(floor(oLightNormal.x * 31) * 8 + floor(oLightNormal.y * 7))/255;
    oLightNormal = vPos.z/255;
}

float4 ps20DrawObjectForPointLight( in float2 TextureCoor: TEXCOORD0,
                                    in float4 LightNormal: COLOR0 ) : COLOR
{
// used LightColor, NormalsPointLight, DecodeTexture, RenderTargetTexture
return LightNormal;
    float4 color = tex2D(RenderTarget, TextureCoor);
    float  light = tex3D(LightCalc, float3(color.a, LightNormal.x, LightNormal.y));
    return color * LightColor*/*light * */LightNormal.z;//(color * diff_spec.x + diff_spec.y) * LightColor * 2;
/*    float4 color     = tex2D(RenderTarget, TextureCoor);
    float4 diff_spec = tex2D(Decode, float2(color.a, LightNormal.a));//, LightNormal.y));
    return color * LightColor * diff_spec.r * 2;//(color * diff_spec.x + diff_spec.y) * LightColor * 2;*/
}

technique DrawObjectForPointLight
{
    pass P0
    {        
//        Sampler[0]   = <RenderTarget>;
//        Sampler[1]   = <LightCalc>;
        PixelShader  = compile ps_2_0 ps20DrawObjectForPointLight();
        VertexShader = compile vs_1_1 vs10DrawObjectForPointLight();
    }
}
//##########################################################################################################
//     GBuffer
float4 ps20DrawDecode( in float2 TextureCoor: TEXCOORD0,
                       in float4 Diffuse:     COLOR0,
                       in float4 Specular:    COLOR1 ) : COLOR
{
    float4 gbuffer  = tex2D(GBuffer, TextureCoor);
    return tex2D(Decode, gbuffer.bg);
}

technique DrawDecode
{
    pass P0
    {        
        Sampler[0]   = <GBuffer>;
        Sampler[1]   = <Decode>;
        PixelShader  = compile ps_2_0 ps20DrawDecode();
    }
}

//##########################################################################################################
//         

texture PaletteTexture;
sampler Palette = 
sampler_state
{
    Texture = <PaletteTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
};

float4 ps20DrawPaletted( in float2 TextureCoor: TEXCOORD0,
                         in float4 Diffuse:     COLOR0,
                         in float4 Specular:    COLOR1 ) : COLOR
{
    float2 buffer = tex2D(Surface, TextureCoor);
    float4 color  = tex2D(Palette, buffer);
    color.a = buffer.y;
    return color * Diffuse + Specular;
}

technique DrawPaletted
{
    pass P0
    {        
        Sampler[0]   = <Surface>;
        Sampler[1]   = <Palette>;
        PixelShader  = compile ps_2_0 ps20DrawPaletted();
        VertexShader = compile vs_1_1 vs10VertexTransform();
    }
}

//##########################################################################################################
//   

void vs10DrawShadowVolume( float3 vPos          : POSITION,
                           out float4 oPosition : POSITION )
{
// used LightCoor, LightRadius2
//    vPos      = vPos * TransformScale + TransformShift;//   
    bool second = false;
    if ( vPos.z < 0 )
    {
        vPos.z = -vPos.z;
        second = true;
    }
    // tranform the position/normal into view space
    oPosition = mul(float4(vPos, 1.0f), mWorldView);
    //         
    if ( second )
    {
        oPosition.xyz = LightCoor + normalize(oPosition.xyz - LightCoor) * LightRadius2;
        //       z = 0    
    }
//    vPos = vPos + normalize(vPos - LightCoor) * LightRadius;
//    oPosition.xyz += normalize(oPosition.xyz - LightCoor) * 50;

    oPosition = mul(oPosition, mView);
    oPosition = mul(oPosition, mProjection);
}

technique DrawShadowVolume
{
    pass P0
    {        
        VertexShader = compile vs_1_1 vs10DrawShadowVolume();
    }
}

//##########################################################################################################
// draw normals, depth, material in GBuffer

void vs10DrawGBuffer( float3 vPos          : POSITION,
                      out float4 oPosition : POSITION,
                      out float4 oDiffuse  : COLOR0,
                      out float2 oTex      : TEXCOORD0 )
{
    // tranform the position/normal into view space
//    vPos         = vPos * TransformScale + TransformShift;//   
    oPosition    = mul(float4(vPos, 1.0f), mWorldView);
    oDiffuse.a   = saturate(oPosition.z/512 + 1.0/255);
    oDiffuse.rgb = 1;//Diffuse.rgb;
    oPosition    = mul(oPosition, mView);
    oPosition    = mul(oPosition, mProjection);

    vPos.y       = vPos.y * ASPECT_RATIO - vPos.z;
    oTex         = (vPos.xy + TexShift) / TexSize;
}
float4 ps11DrawGBuffer( in float2 TextureCoor: TEXCOORD0,
                        in float4 Diffuse:     COLOR0 ) : COLOR
{
    // GBuffer - a:z, rg:normal, b:material
    float4 color = tex2D(Surface, TextureCoor);
    return color * Diffuse;// + float4(ObjectDirection, 0, 0, 0); //+Direction
}

technique DrawGBuffer
{
    pass P0
    {        
//        Sampler[0] = <Surface>;
        VertexShader = compile vs_1_1 vs10DrawGBuffer();
//        PixelShader = compile ps_1_1 ps11DrawGBuffer();
    }
}

//##########################################################################################################
float2 ScreenXY;
float2 ScreenShiftXY;
// Draw distortion sprite
void vs11DrawDistortion( float3 vPos          : POSITION,
                         out float4 oPosition : POSITION,
                         out float2 oTex      : TEXCOORD0,
                         out float2 oTex1     : TEXCOORD1 )
{
    // tranform the position/normal into view space
//    vPos      = vPos * TransformScale + TransformShift;//   
    oPosition = mul(float4(vPos, 1.0f), mWorldView);
    oPosition = mul(oPosition, mView);
    oTex1  = (oPosition + ScreenShiftXY) / ScreenXY;
    oPosition = mul(oPosition, mProjection);

    vPos.y = vPos.y * ASPECT_RATIO - vPos.z;
    oTex   = (vPos.xy + TexShift) / TexSize;
//    oTex1  = (vPos.xy + TexShift) / 256;//oPosition.xy * TargetMul + TargetShift;
}
technique DrawDistortion
{
    pass P0
    {        
        VertexShader = compile vs_1_1 vs11DrawDistortion();
    }
}


//##########################################################################################################
// draw object to MRT normals, depth, material in GBuffer

/*void vs11DrawMRT( float3 vPos          : POSITION,
                  out float4 oPosition : POSITION,
                  out float4 oDiffuse  : COLOR0,
                  out float2 oTex      : TEXCOORD0,
                  out float2 oTex2     : TEXCOORD1 )
{
    // tranform the position/normal into view space
    vPos         = vPos * TransformScale + TransformShift;//   
    oPosition    = mul(float4(vPos, 1.0f), mWorldView);
    oDiffuse.a   = saturate(oPosition.z/512);
    oDiffuse.rgb = 1;
//    oDiffuse = Diffuse;
    oPosition    = mul(oPosition, mView);
    oPosition    = mul(oPosition, mProjection);

    vPos.y       = vPos.y * ASPECT_RATIO - vPos.z;
    oTex         = (vPos.xy + TexShift) / TexSize;
    oTex2        = (vPos.xy + TexShift + float2(0, TexSize.y/2)) / TexSize;
}
struct PS_OUTPUT
{
    float4 Color:       COLOR0;
    float4 Data:        COLOR1;
};
PS_OUTPUT ps11DrawMRT( in  float2 iTextureCoor: TEXCOORD0,
                  in  float2 iTextureCoor2:TEXCOORD1,
                  in  float4 iZ:           COLOR0)
//                  out float4 oColor:       COLOR0,
//                  out float4 oData:        COLOR1 )
{
    PS_OUTPUT o;
    o.Color = tex2D(Surface, iTextureCoor) * Diffuse + Specular;
    o.Data  = tex2D(Surface, iTextureCoor2) * iZ + float4(ObjectDirection, 0, 0, 0);
    return o;
}

technique DrawMRT
{
    pass P0
    {        
        Sampler[0] = <Surface>;
        VertexShader = compile vs_1_1 vs11DrawMRT();
        PixelShader = compile ps_1_1 ps11DrawMRT();
    }
}
*/