

//float4 LightPosition;


//##########################################################################################################
texture RenderTargetTexture;
half4  LightColor;
half4  ZCoeff;

sampler RenderTarget = 
sampler_state
{
    Texture = <RenderTargetTexture>;
    MinFilter = POINT;
    MagFilter = POINT;
};

//#define ASPECT_RATIO (4096.0 / 5793.0)
half4 ps20DrawLight
    (
    in half2 TextureCoor : TEXCOORD0,
    in half4 Coor        : TEXCOORD1
    ) : COLOR
{
    half4 color = tex2D(RenderTarget, TextureCoor);
    half4 c = Coor + color.a * ZCoeff;
//    return color * (1 - dot(Coor, Coor));
//    return color * (LightColor / (dot(Coor, Coor) + 0.04) - 0.2);
//    float intensive = dot(Coor, Coor); intensive = 42 * intensive * (intensive - 1) + 5;
//    float intensive = 0.2 / (dot(Coor, Coor) + 0.02) - 0.2;
//    float intensive = 1 / (dot(Coor, Coor) + 0.00) - 1;

//    float intensive = 1 / dot(Coor, Coor) - 1;
//    return LightColor * intensive * color;
//    return LightColor * color * (1 / dot(Coor, Coor) - 1);
//    color.a = 1;
    return color * (LightColor / dot(c, c) - LightColor);
}
technique DrawLight20
{
    pass P0
    {        
        Sampler[0] = <RenderTarget>;
        PixelShader = compile ps_2_0 ps20DrawLight();
/*        PixelShader =
             asm
             {
                 ps_2_0
                 def    c0, 0.2, 0.2, 0.2, 0.2 // LightColor
                 def    c1, 0.0, 4.0, -4.0, 0.0 // ZCoeff
                 dcl    t0.xy
                 dcl    t1.xyzw
                 dcl_2d s0
                 texld_pp  r0, t0, s0
                 mad r1, r0.aaaa, c1, t1
                 dp4_pp r1.a, r1, r1
                 mul_pp r0, r0, c0
                 rcp_pp r1.a, r1.a
                 mad_pp r0, r1.aaaa, r0, -r0
                 mov_pp    oC0, r0
             };*/
    }
    }

float4 ps10DrawLight
    (
    in float2 TextureCoor : TEXCOORD0,
    in float3 Coor        : TEXCOORD1
    ) : COLOR
{
    float4 color  = tex2D(RenderTarget, TextureCoor);

    float3 c = 2 * (Coor - float3(0.5, 0.5, 0.5)) + color.a * ZCoeff;
//    float coeff = saturate(dot(c, c));
//    coeff = coeff * (coeff < 0.5? 1.0: 2.0);
//    return LightColor * color * saturate(1 - coeff) * 4;
    return LightColor * color * saturate(1.0 - dot(c, c)) * 4;

//    Coor += color.a * ZCoeff;
//    float intensive = saturate(1 - dot(Coor, Coor));
//    return 4 * (LightColor * color * intensive);
}

technique DrawLight10
{
    pass P0
    {        
        Sampler[0] = <RenderTarget>;
        PixelShader = compile ps_1_1 ps10DrawLight();
/*asm
{
    ps_1_1
    
//    def c0, 0.7, 0.7, 0.7, 0.7
    def    c1, 0.0, 4.0, -4.0, 0.0 // ZCoeff
    def    c2, 1.1, 1.1, 1.1, 1.1
    def    c3, 2.9, 1.9, 1.9, 2.9

    tex t0
    texcoord t1

    mad r1, t0.a, c1, t1_bx2
    dp3_x2 r0, r1, r1
//    mul r1, r1, c2

//    mad_sat r1, c0, r1
//    cnd r1, r0.a, c2.a, c3.a
//    mul r1, r1.a, r0.a
    mul_x4  r0, t0, 1 - r0

//    mul_x4 r0, t0, 1 - r1

};*/
    }
}

//##########################################################################################################
float4 Specular;
float4 Diffuse;//: register (c0);
float4 TexShift;
float4 TexSize;
float4x4 mWorldView;
float4x4 mProjection;
float4x4 mView;

// Output structure for WorldTransform
struct VS_OUTPUT_TEXCOORD0
{
    float4 Position : POSITION;
    float4 Diffuse  : COLOR0;
    float4 Specular : COLOR1;
    float2 Texture  : TEXCOORD0;
};

float ShiftZ;
// Transform objects into the view, also setting the appropriate blur factor
VS_OUTPUT_TEXCOORD0 vs10VertexTransformWithZ
    (
    float3 vPos       : POSITION,
    float2 vTexCoord0 : TEXCOORD0
    )
{
    VS_OUTPUT_TEXCOORD0 Output;
  
//    Output.Diffuse.a = max(vPos/*Output.Position*/.z + ShiftZ, 2) / 512;
    // tranform the position/normal into view space
    Output.Position = mul(float4(vPos, 1.0f), mWorldView);
    Output.Diffuse.a = max(Output.Position.z, 2) / 512;
    Output.Position = mul(Output.Position, mView);
    Output.Position = mul(Output.Position, mProjection);

    Output.Diffuse.rgb = Diffuse.rgb;
    Output.Specular = Specular;
    
//    Output.Texture = (float2(vPos.x, vPos.y * (4096.0f/5793.0f) - vPos.z) + ShiftTex.xy) / SizeTex.xy;//float2(1.0-vTexCoord0.x, vTexCoord0.y);
    vPos.y = vPos.y * 0.70706 - vPos.z;
    Output.Texture = ((vPos + TexShift) / TexSize).xy;
//    Output.Texture = (vPos * TexSize + TexShift).xy;
//    Output.Texture = vTexCoord0;
    
    return Output;    
}
VS_OUTPUT_TEXCOORD0 vs10VertexTransform
    (
    float3 vPos       : POSITION,
    float2 vTexCoord0 : TEXCOORD0
    )
{
    VS_OUTPUT_TEXCOORD0 Output;
  
    // tranform the position/normal into view space
    Output.Position = mul(float4(vPos, 1.0f), mWorldView);
    Output.Position = mul(Output.Position, mView);
    Output.Position = mul(Output.Position, mProjection);

    Output.Diffuse = Diffuse;
    Output.Specular = Specular;

    vPos.y = vPos.y * (4096.0f/5793.0f) - vPos.z;
    Output.Texture = ((vPos + TexShift) / TexSize).xy;
    return Output;    
}
float4 ps10DrawObjectWithZ
    (
//    in float4 diffuse     : COLOR0,
    in float2 TextureCoor : TEXCOORD0
    ) : COLOR
{
    float4 color  = tex2D(RenderTarget, TextureCoor);
//    color = color * Diffuse + Specular;
    return color;
}
technique DrawObjectWithZ
{
    pass P0
    {        
//        Sampler[0] = <RenderTarget>;
        VertexShader = compile vs_1_1 vs10VertexTransformWithZ();
        fvf = XYZ;
//        PixelShader = compile ps_1_1 ps10DrawObjectWithZ();
/*        PixelShader =
             asm
             {
                 ps_1_1
                 tex t0
                 mad r0, t0, v0, v1
             };*/

    }
}
//##########################################################################################################
technique DrawObject
{
    pass P0
    {        
        VertexShader = compile vs_1_1 vs10VertexTransform();
        fvf = XYZ;
    }
}
//##########################################################################################################
technique DrawObjectWithoutShader
{
    pass P0
    {        
        fvf = XYZ | Tex1;
    }
}

//##########################################################################################################
struct OUT
{
    float4 color: COLOR0;
    float  depth: Depth;
};
OUT ps20DrawBackWithZ
    (
    in float2 TextureCoor : TEXCOORD0
    )
{
    struct OUT ret;
    float4 color  = tex2D(RenderTarget, TextureCoor);
    ret.color = color;
    ret.depth = color.a * 0.0625 + 0.015625;
    return ret;
}
technique DrawBackWithZ
{
    pass P0
    {        
        Sampler[0] = <RenderTarget>;
        PixelShader = compile ps_2_0 ps20DrawBackWithZ();
/*        PixelShader =
            asm
            {
                ps_2_0
                def    c0, 0.015625, 0, 0, 0.0625
                dcl    t0.xy
                dcl_2d s0
                texld  r0, t0, s0
                mov    oC0, r0
                mad_pp r1.a, r0.a, c0.w, c0.x
                mov    oDepth, r1.a
            };*/
    }
}
//##########################################################################################################
float4 ps10VolumeFog
    (
    in float2 TextureCoor: TEXCOORD0,
    in float4 Diffuse:     COLOR0,
    in float4 Specular:    COLOR1
    ) : COLOR
{
    float4 color  = tex2D(RenderTarget, TextureCoor);
    color = color * Diffuse + Specular;
    return color;
}

technique DrawVolumeFog
{
    pass P0
    {        
        Sampler[0] = <RenderTarget>;
        PixelShader = compile ps_1_1 ps10VolumeFog();
/*asm
{
    ps_1_1
    
//    def c0, 0.7, 0.7, 0.7, 0.7
    def    c1, 0.0, 4.0, -4.0, 0.0 // ZCoeff
    def    c2, 1.1, 1.1, 1.1, 1.1
    def    c3, 2.9, 1.9, 1.9, 2.9

    tex t0
    texcoord t1

    mad r1, t0.a, c1, t1_bx2
    dp3_x2 r0, r1, r1
//    mul r1, r1, c2

//    mad_sat r1, c0, r1
//    cnd r1, r0.a, c2.a, c3.a
//    mul r1, r1.a, r0.a
    mul_x4  r0, t0, 1 - r0

//    mul_x4 r0, t0, 1 - r1

};*/
    }
}
